package labirinto.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import labirinto.Player;
import labirinto.tests.LabirintoGame;

/**
 * COma da titolo. Necessita dell'istanza di player che contiene le mosse che da
 * qui vengono impartite
 * 
 * @author koelio
 * 
 */
public class ControlPanel extends JPanel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public Player player;
	JButton up = new JButton("Up");
	JButton down = new JButton("Down");
	JButton left = new JButton("Left");
	JButton right = new JButton("Right");
	JButton rules = new JButton("Istruzioni");

	public ControlPanel(Player player) {
		this.player = player;
		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new BorderLayout());

		up.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				up();
			}
		});

		left.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				left();
			}
		});

		right.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				right();
			}
		});

		down.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				down();
			}
		});

		rules.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				rules();
			}
		});

		add(up, BorderLayout.NORTH);
		add(left, BorderLayout.WEST);
		add(right, BorderLayout.EAST);
		add(down, BorderLayout.SOUTH);
		add(rules, BorderLayout.CENTER);

	}

	/**
	 * metodi per direzioni, per capire come funziona il controllo
	 * 
	 * @see Player
	 */
	public void up() {
		player.setDir(1);
	}

	public void left() {
		player.setDir(4);
	}

	public void right() {
		player.setDir(2);
	}

	public void down() {
		player.setDir(3);
	}

	public void rules() {//roba in più
		JDialog dialog = new JDialog(LabirintoGame.getFrame());
		dialog.setSize(400, 200);
		dialog.setVisible(true);
		setLayout(new BorderLayout());

		dialog.getContentPane().add(new JLabel("<html>Devi raggiungere la casella del tesoro " +
				"in mezzo, però, ci sono altre stanze" +
				"che hanno mura, porte, teletrasporti e baratri!<br><br>" +
				"Il muro non ti fa muovere.<br><br>" +
				"La porta ti fa passare.<br><br>" +
				"Il teletrasporto crea un wormhole che " +
				"ti porta in una stanza (che tu non sai)<br><br>" +
				"Se cadi nel baratro, MUORI.<br><br>" +
				"Made by Paolo B.</html>"), BorderLayout.NORTH);

		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		dialog.setLocation((int) (dim.getWidth() - dialog.getWidth()) / 2,
				(int) (dim.getHeight() - dialog.getHeight()) / 2);
	}

}
